 %-------------------------------------------------------------------------%
% Filename: figs_App_D_4_data.m  
% Part of the paper "CS4ML: A general framework for active learning with 
% arbitrary data based on Christoffel functions"
%
% Description: generates and saves the data for Figure 12 in Appendix D, 
% training error versus the number of epochs.
%-------------------------------------------------------------------------%
% Inputs:
% fig_num - figure number (3)
% row_num - row number (either 1, 2 or 3)
% col_num - column number (either 1 or 2)
%-------------------------------------------------------------------------%

function fig_App_D_4_data(fig_num,row_num,col_num)
 
% Define name
fig_name = ['fig_AppD','_',num2str(fig_num),'_',num2str(row_num),'_',num2str(col_num)];

% Define parameters
nb_trials = 20;
nb_epochs = 225000; 
num_arch  = 2;
nb_samp   = 2;

%%% Main loop %%%
k = 0;
 
y_values_data = zeros(nb_epochs, nb_trials, num_arch*2);
x_values_data = zeros(nb_epochs, nb_trials, num_arch*2);  

% if col_num == 1 
    for case_num = 1:num_arch  
            
        % load parameters
        load_param_fig_App_D_4
                                      
        disp(filename)
        load([filename '_extracted_data.mat']);
        
        % compute nb epochs vals 
        nb_total_epochs = sum(nb_epochs_vec_save_data(1,1,:));

        % save data for samp method and trial
        for samp_num = 1:nb_samp
            for t = 1:nb_trials 
                x_values_samp(:,t,samp_num) = 1:nb_total_epochs;
                y_values_samp(:,t,samp_num) = training_loss_save_data(samp_num,t,10:end);
            end
        end

        nb_epochs_vec = (nb_epochs_vec_save_data(1,1,:));
 
        % save full data  
        x_values_data(:,:, case_num+k:case_num+k+1) = x_values_samp;
        y_values_data(:,:, case_num+k:case_num+k+1) = y_values_samp;    
        z_values_data = cumsum(nb_epochs_vec(:)');
        k = k+1;
    end

%%% Save data %%%
save(['../../data/Figure App D 4/',fig_name], 'x_values_data', 'y_values_data','z_values_data');

end